from flask import Flask, jsonify
from flask_cors import CORS
from get_user import get_user

app = Flask(__name__)

# 特定のオリジンだけを許可する
cors = CORS(app, resources={r"/*": {"origins": ["http://localhost"]}})

@app.route("/user")
def user():
    users = get_user()
    return jsonify(users), 200

if __name__ == "__main__":
    app.run(port=3000, host='0.0.0.0', debug=True)
