import psycopg2

def get_user():
    try:
        # `with`で接続を管理
        with psycopg2.connect(host="db", database="postgres", user="postgres", password="postgres", port=5432) as connection:
            # `with`でカーソルを管理
            with connection.cursor() as cursor:
                # SQLクエリを実行
                query = "SELECT * FROM users;"
                cursor.execute(query)
                # 結果を取得して処理
                rows = cursor.fetchall()
                users = []
                for row in rows:
                    print(row)
                    id, name = row
                    users.append({"id": id, "name": name})
                return users
    except psycopg2.Error as e:
        print("データベース操作中にエラーが発生しました:", e)

if __name__ == "__main__":
    id, name = get_user()
    print(id)
    print(name)