import psycopg2

try:
    # `with`で接続を管理
    with psycopg2.connect(host="db", database="postgres", user="postgres", password="postgres", port=5432) as connection:
        # `with`でカーソルを管理
        with connection.cursor() as cursor:
            # SQLクエリを実行
            query = "SELECT * FROM users;"
            cursor.execute(query)
            # 結果を取得して処理
            rows = cursor.fetchall()
            for row in rows:
                print(row)
except psycopg2.Error as e:
    print("データベース操作中にエラーが発生しました:", e)